var flambeCanvas;

/**
 * Get Audio Manager functions (call from Gamecore)
 * 
 */
function get_audioManager()
{
	return audioEngine;
}

/**
 * All Audio Manager functions
 * 
 */
var audioEngine =
{
	playSound:function(name,interrupt,delay,offset,loop,volume,pan)
	{
		return createjs.Sound.play(name,interrupt,delay,offset,loop,volume,pan);
	},
	
	setMasterVolume:function(value)
	{
		createjs.Sound.setVolume(value);
	},
	
	checkReady:function()
	{
		return createjs.Sound.isReady();
	},
	
	checkIfSndLoaded:function(snd)
	{
		return createjs.Sound.loadComplete(snd);
	}
}

var funcToCallOnLoad = null;

/**
 * Audio Manager
 * 
 */
function audioManager() 
{
	var context = this;
	var eventType = "";
	var nbSoundsToLoad = 0;
	var nbSoundsLoaded = 0;
	
	/**
	 * Init
	 * 
	 */
	function init()
	{	
		//Deactivated for now
		//return;
	
		var mobile = navigator.userAgent.match(/iPhone|iPad|iPod/i) || navigator.userAgent.match(/Android/i) || (navigator.userAgent.indexOf("Silk") !== -1);
		
		if (!mobile)
		{
			// Web
			handleClick();			
		}
		else
		{
			// Mobile
			eventType = "touchstart";
			// Register event for initialization
			this.checkForCanvas = function()
			{
				flambeCanvas = document.getElementById("gameCanvas");
				if (flambeCanvas)
				{
					flambeCanvas.addEventListener(eventType, handleClick, false);
				}else{
					window.setTimeout("checkForCanvas",200);
				}
			};
			
			this.checkForCanvas();
		}		
	}

	/**
	 * Click event
	 * 
	 */
	function handleClick()
	{
		// Remove event
		if (eventType != "") flambeCanvas.removeEventListener(eventType, handleClick, false);
		
		//createjs.Sound.registerPlugins([createjs.WebAudioPlugin, createjs.HTMLAudioPlugin, createjs.FlashPlugin]);
		
		// Init audio
		if (!createjs.Sound.isReady())
		{			
			// Init engine
			if (!createjs.Sound.initializeDefaultPlugins()) {				
				funcToCallOnLoad();
				return;
			}
					
			nbSoundsToLoad = soundsManifest.length;
			createjs.Sound.alternateExtensions = ["mp3"];
			createjs.Sound.addEventListener("fileload", handleLoad);
			createjs.Sound.registerManifest(soundsManifest);
		}else{
			funcToCallOnLoad();
		}
	}

	/**
	 * Load end event
	 * 
	 * @param	event
	 */
	function handleLoad(event)
	{		
		nbSoundsLoaded++;
		//console.log("Preloaded:", event.id," || ", event.src);
		if (nbSoundsLoaded >= nbSoundsToLoad)
		{	
			//console.log("sounds loading complete");
			if (funcToCallOnLoad)
			funcToCallOnLoad();			
		}
	}
	
	function onSoundsLoaded(funcToCall)
	{
		funcToCallOnLoad = funcToCall;
	}

	//Public methods
	this.init = init;
	this.onSoundsLoaded = onSoundsLoaded;
	
	return this;
}

function onSoundsLoaded(funcToCall)
{
	audioManager().onSoundsLoaded(funcToCall);
}